<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet 
  version="1.1" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:javaFile="javaFile:java.io.File"
  xmlns:saxon="http://icl.com/saxon"
  extension-element-prefixes="saxon"
  exclude-result-prefixes="saxon javaFile">

<xsl:script language="java" implements-prefix="javaFile" 
    src="java:java.io.File"/>

<xsl:output method="xml" indent="yes"/>
<xsl:strip-space elements="*"/>
<!--<xsl:include href = "publishtest_doctrack.xsl"/>-->
<xsl:include href = "getauthorfile.xsl"/>
  
<!-- insert file IF PUBLISHING; all published files will have <api> tags. -->


<xsl:template match="/">
  <xsl:copy>
    <xsl:apply-templates select="node()"/>
  </xsl:copy>
</xsl:template>


<!-- default template: copy current node -->
<xsl:template match="*">
  
  <xsl:variable name="name" select="name(.)"/>
  <xsl:element name="{$name}">
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates/>
  </xsl:element>
  
</xsl:template>


<!-- linked entities -->
<xsl:template match="eventlink | methodlink | propertylink">
  <!--
    <xsl:message>
      LINK: <xsl:value-of select="name()"/>
    </xsl:message>
-->
    <xsl:choose>
  <xsl:when test="not(@docset='microsoft')">
    <xsl:element name="{name()}">
      <xsl:copy-of select="@*"/>
      <xsl:copy-of select="*"/>
      <xsl:call-template name="insertshortdescription">
        <xsl:with-param name="namespace" select="namespace"/>
        <xsl:with-param name="class" select="class"/>
        <xsl:with-param name="member" select="event/text() | method/text() | property/text()"/>
        <xsl:with-param name="authorfile">
          <xsl:if test="self::eventlink">
            <xsl:value-of select="concat('chopdata/',namespace,'/','classes/', (class/text()|interface/text()),'/events/',(class/text()|interface/text()),'.',event/text(),'.xml')"/>
          </xsl:if>
          <xsl:if test="self::methodlink">
            <xsl:value-of select="concat('chopdata/',namespace,'/','classes/',(class/text()|interface/text()),'/methods/',(class/text()|interface/text()),'.',method/text(),'.xml')"/>
          </xsl:if>
          <xsl:if test="self::propertylink">
            <xsl:value-of select="concat('chopdata/',namespace,'/','classes/',(class/text()|interface/text()),'/properties/',(class/text()|interface/text()),'.',property/text(),'.xml')"/>
          </xsl:if>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:element>
  </xsl:when>
  <xsl:otherwise>
    <xsl:copy-of select="."/>
  </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!-- published entities -->
<xsl:template match="/namespace | /namespace/class | /namespace/interface | /namespace/struct | /namespace/type | /namespace/routine | /namespace/constant | /namespace/const | /namespace/variable | members/method | members/field | members/event | members/property">
  
  <xsl:variable name="publishthis">
  <xsl:text>yes</xsl:text>
  <!--<xsl:call-template name="publishtest_doctrack"/>-->
  </xsl:variable>
  
  <xsl:if test="$publishthis = 'yes'">
    <xsl:variable name="name" select="name(.)"/>
    <xsl:element name="{$name}">
      
      <xsl:copy-of select="@*"/>
      
      <xsl:apply-templates/>
      
      <xsl:call-template name="insertdescription"/>        
      
    </xsl:element>
  </xsl:if>
    
</xsl:template>


<!-- INSERT DESCRIPTION -->

<xsl:template name="insertdescription">

    <xsl:variable name="authorfile">
      <xsl:call-template name="getauthorfile"/>
    </xsl:variable>

    <xsl:variable name="filename" 
      select="javaFile:new($authorfile)"/>

    <xsl:if test="javaFile:exists($filename) or name(.)='namespace'">

      <xsl:copy-of select="document($filename)"/>

    </xsl:if>
    
      
</xsl:template>

<!-- INSERT SHORT DESCRIPTION -->

<xsl:template name="insertshortdescription">
  <xsl:param name="namespace"/>
  <xsl:param name="class"/>
  <xsl:param name="member"/>
  <xsl:param name="authorfile"/>

    <xsl:variable name="filename" 
      select="javaFile:new($authorfile)"/>

    <!--
    <xsl:message>
      Publishing LINK TO <xsl:value-of select="$filename"/>
    </xsl:message>
-->
    <xsl:if test="javaFile:exists($filename) or name(.)='namespace'">
    <!--
      <xsl:message>LINK AUTHOR FILE FOUND: <xsl:copy-of select="$filename"/></xsl:message>
-->
      <xsl:copy-of select="document($filename)//descrShort"/>
    </xsl:if>
    
      <!--
    <xsl:if test="not(javaFile:exists($filename)) 
                  and not(name(.)='namespace')">
      <xsl:message>
        link author file not found: <xsl:copy-of select="$filename"/>
      <xsl:copy-of select="name(.)"/>
    </xsl:message>
      </xsl:if>
    -->
      
</xsl:template>

</xsl:stylesheet>

